/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.watchers.common.BlockedAttackerWatcher;

class MonstrousStepEffect
extends RequirementEffect {
    MonstrousStepEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "Up to one other target creature blocks it this turn if able";
    }

    private MonstrousStepEffect(MonstrousStepEffect effect) {
        super((RequirementEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        BlockedAttackerWatcher watcher = (BlockedAttackerWatcher)game.getState().getWatcher(BlockedAttackerWatcher.class);
        return permanent != null && watcher != null && !watcher.creatureHasBlockedAttacker(game.getPermanent(source.getFirstTarget()), permanent, game) && permanent.getId().equals(((Target)source.getTargets().get(1)).getFirstTarget()) && permanent.canBlock(source.getFirstTarget(), game);
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return true;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        return source.getFirstTarget();
    }

    public MonstrousStepEffect copy() {
        return new MonstrousStepEffect(this);
    }
}

