/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MoonlightHuntEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    MoonlightHuntEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose target creature you don't control. Each creature you control that's a Wolf or a Werewolf deals damage equal to its power to that creature";
    }

    private MoonlightHuntEffect(MoonlightHuntEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoonlightHuntEffect copy() {
        return new MoonlightHuntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetCreature != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                targetCreature.damage(permanent.getPower().getValue(), permanent.getId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.WOLF.getPredicate(), (Predicate)SubType.WEREWOLF.getPredicate()));
    }
}

