/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class MoonshaePixieWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    MoonshaePixieWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && ((DamagedEvent)event).isCombatDamage()) {
            this.players.add(event.getTargetId());
        }
    }

    public void reset() {
        this.players.clear();
        super.reset();
    }

    static int getDamaged(UUID playerId, Game game) {
        return ((MoonshaePixieWatcher)game.getState().getWatcher(MoonshaePixieWatcher.class)).players.stream().filter(game.getOpponents(playerId)::contains).mapToInt(x -> 1).sum();
    }
}

