/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class MoorlandRescuerTarget
extends TargetCardInYourGraveyard {
    private final int xValue;

    MoorlandRescuerTarget(int xValue, Ability source, Game game) {
        super(0, Integer.MAX_VALUE, MoorlandRescuerTarget.makeFilter(xValue, source, game));
        this.xValue = xValue;
        this.notTarget = true;
    }

    private MoorlandRescuerTarget(MoorlandRescuerTarget target) {
        super((TargetCardInYourGraveyard)target);
        this.xValue = target.xValue;
    }

    public MoorlandRescuerTarget copy() {
        return new MoorlandRescuerTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return super.canTarget(playerId, id, source, game) && CardUtil.checkCanTargetTotalValueLimit((Collection)this.getTargets(), (UUID)id, m -> m.getPower().getValue(), (int)this.xValue, (Game)game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        return CardUtil.checkPossibleTargetsTotalValueLimit((Collection)this.getTargets(), (Set)super.possibleTargets(sourceControllerId, source, game), m -> m.getPower().getValue(), (int)this.xValue, (Game)game);
    }

    public String getMessage(Game game) {
        int selectedValue = this.getTargets().stream().map(arg_0 -> ((Game)game).getObject(arg_0)).filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        return super.getMessage(game) + " (selected total power " + selectedValue + ")";
    }

    private static FilterCard makeFilter(int xValue, Ability source, Game game) {
        FilterCreatureCard filter = new FilterCreatureCard("creature cards with total power " + xValue + " or less from your graveyard");
        filter.add(Predicates.not((Predicate)new MageObjectReferencePredicate(source.getSourceObject(game), game)));
        return filter;
    }
}

