/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileAllEffect;
import mage.abilities.effects.common.ExileGraveyardAllPlayersEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;

class MoratoriumStoneEffect
extends OneShotEffect {
    MoratoriumStoneEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target nonland card from a graveyard, all other cards from graveyards with the same name as that card, and all permanents with that name.";
    }

    private MoratoriumStoneEffect(MoratoriumStoneEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoratoriumStoneEffect copy() {
        return new MoratoriumStoneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        if (card == null) {
            return false;
        }
        String cardName = card.getName();
        FilterCard filter1 = new FilterCard();
        filter1.add((Predicate)new NamePredicate(cardName));
        FilterPermanent filter2 = new FilterPermanent();
        filter2.add((Predicate)new NamePredicate(cardName));
        return new ExileGraveyardAllPlayersEffect(filter1).apply(game, source) && new ExileAllEffect(filter2).apply(game, source);
    }
}

