/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapAllControllerEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;

class MoraugFuryOfAkoumDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID connectedTurnMod;
    private boolean enabled;

    MoraugFuryOfAkoumDelayedTriggeredAbility(UUID connectedTurnMod) {
        super((Effect)new UntapAllControllerEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE), Duration.EndOfTurn, true, false);
        this.connectedTurnMod = connectedTurnMod;
    }

    private MoraugFuryOfAkoumDelayedTriggeredAbility(MoraugFuryOfAkoumDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.connectedTurnMod = ability.connectedTurnMod;
        this.enabled = ability.enabled;
    }

    public MoraugFuryOfAkoumDelayedTriggeredAbility copy() {
        return new MoraugFuryOfAkoumDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASE_CHANGED || event.getType() == GameEvent.EventType.COMBAT_PHASE_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.PHASE_CHANGED && this.connectedTurnMod.equals(event.getSourceId())) {
            this.enabled = true;
            return false;
        }
        if (event.getType() == GameEvent.EventType.COMBAT_PHASE_PRE && this.enabled) {
            this.enabled = false;
            return true;
        }
        return false;
    }

    public String getRule() {
        return "At the beginning of that combat, untap all creatures you control.";
    }
}

