/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.SaprolingToken;
import mage.players.Player;

class MorbidBloomEffect
extends OneShotEffect {
    MorbidBloomEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile target creature card from a graveyard, then create X 1/1 green Saproling creature tokens, where X is the exiled card's toughness";
    }

    private MorbidBloomEffect(MorbidBloomEffect effect) {
        super((OneShotEffect)effect);
    }

    public MorbidBloomEffect copy() {
        return new MorbidBloomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        int toughness = card.getToughness().getValue();
        if (toughness < 1) {
            return true;
        }
        return new SaprolingToken().putOntoBattlefield(toughness, game, source, player.getId());
    }
}

