/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.BlackAstartesWarriorToken;
import mage.players.Player;
import mage.util.ManaUtil;
import mage.watchers.common.PlayerLostLifeWatcher;

class MortarionDaemonPrimarchEffect
extends OneShotEffect {
    MortarionDaemonPrimarchEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. If you do, create X 2/2 black Astartes Warrior creature tokens with menace. X can't be greater than the amount of life you lost this turn";
    }

    private MortarionDaemonPrimarchEffect(MortarionDaemonPrimarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public MortarionDaemonPrimarchEffect copy() {
        return new MortarionDaemonPrimarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int lifeLost = ((PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class)).getLifeLost(source.getControllerId());
        Player player = game.getPlayer(source.getControllerId());
        if (lifeLost < 1 || player == null) {
            return false;
        }
        int manaPaid = ManaUtil.playerPaysXGenericMana((boolean)true, (String)"Mortarion, Daemon Primarch", (Player)player, (Ability)source, (Game)game, (int)lifeLost);
        return manaPaid > 0 && new BlackAstartesWarriorToken().putOntoBattlefield(manaPaid, game, source);
    }
}

