/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MowuLoyalCompanionEffect
extends ReplacementEffectImpl {
    MowuLoyalCompanionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature, true);
        this.staticText = "If one or more +1/+1 counters would be put on {this}, that many plus one +1/+1 counters are put on it instead";
    }

    private MowuLoyalCompanionEffect(MowuLoyalCompanionEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowInc((int)event.getAmount(), (int)1), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getData().equals(CounterType.P1P1.getName()) && event.getAmount() > 0) {
            Permanent permanent = game.getPermanent(event.getTargetId());
            if (permanent == null) {
                permanent = game.getPermanentEntering(event.getTargetId());
            }
            return permanent != null && permanent.getId().equals(source.getSourceId()) && permanent.isCreature(game);
        }
        return false;
    }

    public MowuLoyalCompanionEffect copy() {
        return new MowuLoyalCompanionEffect(this);
    }
}

