/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class MuYanlingCelestialWind
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Creatures you control with flying");

    public MuYanlingCelestialWind(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{4}{U}{U}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.YANLING);
        this.setStartingLoyalty(5);
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new BoostTargetEffect(-5, 0, Duration.UntilYourNextTurn).setText("Until your next turn, up to one target creature gets -5/-0."), 1);
        ability.addTarget((Target)new TargetCreaturePermanent());
        this.addAbility((Ability)ability);
        ability = new LoyaltyAbility((Effect)new ReturnToHandTargetEffect(), -3);
        ability.addTarget((Target)new TargetCreaturePermanent(0, 2));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new BoostAllEffect(5, 5, Duration.EndOfTurn, filter, false), -7));
    }

    private MuYanlingCelestialWind(MuYanlingCelestialWind card) {
        super((CardImpl)card);
    }

    public MuYanlingCelestialWind copy() {
        return new MuYanlingCelestialWind(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

