/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.turn.AddExtraTurnControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MuYanlingEffect
extends OneShotEffect {
    MuYanlingEffect() {
        super(Outcome.Tap);
        this.staticText = "tap all creatures your opponents control. You take an extra turn after this one.";
    }

    private MuYanlingEffect(MuYanlingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE, player.getId(), source, game)) {
            creature.tap(source, game);
        }
        return new AddExtraTurnControllerEffect().apply(game, source);
    }

    public MuYanlingEffect copy() {
        return new MuYanlingEffect(this);
    }
}

