/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.m.MuldrothaTheGravetideWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class MuldrothaTheGravetideCastFromGraveyardEffect
extends AsThoughEffectImpl {
    MuldrothaTheGravetideCastFromGraveyardEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "During each of your turns, you may play a land and cast a permanent spell of each permanent type from your graveyard. <i>(If a card has multiple permanent types, choose one as you play it.)</i>";
    }

    private MuldrothaTheGravetideCastFromGraveyardEffect(MuldrothaTheGravetideCastFromGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public MuldrothaTheGravetideCastFromGraveyardEffect copy() {
        return new MuldrothaTheGravetideCastFromGraveyardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (source.isControlledBy(affectedControllerId) && source.isControlledBy(game.getOwnerId(objectId)) && affectedControllerId.equals(game.getActivePlayerId()) && Zone.GRAVEYARD.equals((Object)game.getState().getZone(objectId))) {
            MuldrothaTheGravetideWatcher watcher = (MuldrothaTheGravetideWatcher)game.getState().getWatcher(MuldrothaTheGravetideWatcher.class);
            MageObject mageObject = game.getObject(objectId);
            if (mageObject != null && watcher != null) {
                for (CardType cardType : mageObject.getCardType(game)) {
                    MageObjectReference mor;
                    if (!cardType.isPermanentType() || watcher.permanentTypePlayedFromGraveyard(mor = new MageObjectReference(source.getSourceObject(game), game), cardType)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

