/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MultiformWonder2Effect
extends OneShotEffect {
    public MultiformWonder2Effect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} gets +2/-2 or -2/+2 until end of turn";
    }

    private MultiformWonder2Effect(MultiformWonder2Effect effect) {
        super((OneShotEffect)effect);
    }

    public MultiformWonder2Effect copy() {
        return new MultiformWonder2Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            int power = 2;
            int toughness = -2;
            String message = "Should " + sourceObject.getLogName() + " get -2/+2 instead of +2/-2?";
            if (controller.chooseUse(Outcome.Neutral, message, source, game)) {
                power *= -1;
                toughness *= -1;
            }
            game.addEffect((ContinuousEffect)new BoostSourceEffect(power, toughness, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

