/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class MutinyEffect
extends OneShotEffect {
    MutinyEffect() {
        super(Outcome.Damage);
        this.staticText = "Target creature an opponent controls deals damage equal to its power to another target creature that player controls";
    }

    private MutinyEffect(MutinyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MutinyEffect copy() {
        return new MutinyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent firstTarget = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (firstTarget != null) {
            int damage = firstTarget.getPower().getValue();
            Permanent secondTarget = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
            if (damage > 0 && secondTarget != null) {
                secondTarget.damage(damage, firstTarget.getId(), source, game);
            }
        }
        return true;
    }
}

