/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MyrBattlesphereEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MyrBattlesphereTriggeredAbility
extends TriggeredAbilityImpl {
    public MyrBattlesphereTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MyrBattlesphereEffect(), true);
    }

    private MyrBattlesphereTriggeredAbility(MyrBattlesphereTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MyrBattlesphereTriggeredAbility copy() {
        return new MyrBattlesphereTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent source = game.getPermanent(event.getSourceId());
        if (source != null && source.getId().equals(this.getSourceId())) {
            UUID defenderId = game.getCombat().getDefenderId(event.getSourceId());
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(defenderId, game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} attacks, you may tap X untapped Myr you control. If you do, {this} gets +X/+0 until end of turn and deals X damage to the player or planeswalker it's attacking.";
    }
}

