/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.token.MyrToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class MyrIncubatorEffect
extends SearchEffect {
    private static final FilterCard filter = new FilterCard();
    int tokensToCreate = 0;

    MyrIncubatorEffect() {
        super(new TargetCardInLibrary(0, Integer.MAX_VALUE, filter), Outcome.Neutral);
        this.staticText = "Search your library for any number of artifact cards, exile them, then create that many 1/1 colorless Myr artifact creature tokens. Then shuffle";
    }

    private MyrIncubatorEffect(MyrIncubatorEffect effect) {
        super((SearchEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.searchLibrary(this.target, source, game)) {
            if (!this.target.getTargets().isEmpty()) {
                this.tokensToCreate = this.target.getTargets().size();
                controller.moveCards((Cards)new CardsImpl((Collection)this.target.getTargets()), Zone.EXILED, source, game);
            }
            CreateTokenEffect effect = new CreateTokenEffect((Token)new MyrToken(), this.tokensToCreate);
            effect.apply(game, source);
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public MyrIncubatorEffect copy() {
        return new MyrIncubatorEffect(this);
    }

    static {
        filter.add((Predicate)CardType.ARTIFACT.getPredicate());
    }
}

