/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MyrkulsEdictEffect
extends OneShotEffect {
    MyrkulsEdictEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an opponent. That player sacrifices a creature of their choice";
    }

    private MyrkulsEdictEffect(MyrkulsEdictEffect effect) {
        super((OneShotEffect)effect);
    }

    public MyrkulsEdictEffect copy() {
        return new MyrkulsEdictEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetOpponent target = new TargetOpponent(true);
        if (!target.choose(this.outcome, source.getControllerId(), source.getId(), source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        SacrificeEffect sacrificeEffect = new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, 1, "");
        sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(opponent.getId()));
        return sacrificeEffect.apply(game, source);
    }
}

