/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MysterioMasterOfIllusionTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.IllusionVillainToken;
import mage.game.permanent.token.Token;

class MysterioMasterOfIllusionEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.VILLAIN);

    MysterioMasterOfIllusionEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 3/3 blue Illusion Villain creature token for each nontoken Villain you control. Exile those tokens when {this} leaves the battlefield";
    }

    private MysterioMasterOfIllusionEffect(MysterioMasterOfIllusionEffect effect) {
        super((OneShotEffect)effect);
    }

    public MysterioMasterOfIllusionEffect copy() {
        return new MysterioMasterOfIllusionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        IllusionVillainToken token = new IllusionVillainToken();
        token.putOntoBattlefield(game.getBattlefield().count(filter, source.getControllerId(), source, game), game, source);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new MysterioMasterOfIllusionTriggeredAbility((Token)token, game), source);
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

