/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MysticReflectionGainAbilityEffect
extends ContinuousEffectImpl {
    private final Ability ability;

    MysticReflectionGainAbilityEffect(Ability ability) {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
    }

    private MysticReflectionGainAbilityEffect(MysticReflectionGainAbilityEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.ability = effect.ability;
    }

    public MysticReflectionGainAbilityEffect copy() {
        return new MysticReflectionGainAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetedPermanent = (Permanent)game.getState().getValue("MysticReflection" + source.getSourceId().toString());
        if (targetedPermanent == null) {
            return false;
        }
        Card card = targetedPermanent.getMainCard();
        if (card != null && !card.getAbilities().contains(this.ability)) {
            game.getState().addOtherAbility(card, this.ability);
            return true;
        }
        return false;
    }
}

