/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MysticSubdualEffect
extends ContinuousEffectImpl {
    MysticSubdualEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "and loses all abilities";
    }

    private MysticSubdualEffect(MysticSubdualEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MysticSubdualEffect copy() {
        return new MysticSubdualEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        Permanent creature = game.getPermanent(permanent.getAttachedTo());
        if (creature == null) {
            return false;
        }
        creature.removeAllAbilities(source.getSourceId(), game);
        return true;
    }
}

