/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class RevealVariableBlackCardsFromHandCost
extends VariableCostImpl {
    private static final FilterCard filter = new FilterCard("X black cards from your hand");

    RevealVariableBlackCardsFromHandCost() {
        super(VariableCostType.NORMAL, "black cards to reveal");
        this.text = "Reveal " + this.xText + " black cards from your hand";
    }

    private RevealVariableBlackCardsFromHandCost(RevealVariableBlackCardsFromHandCost cost) {
        super((VariableCostImpl)cost);
    }

    public RevealVariableBlackCardsFromHandCost copy() {
        return new RevealVariableBlackCardsFromHandCost(this);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        return new RevealTargetFromHandCost(new TargetCardInHand(0, xValue, filter));
    }

    public int getMinValue(Ability source, Game game) {
        return 0;
    }

    public int getMaxValue(Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            return player.getHand().getCards(filter, game).size();
        }
        return 0;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
    }
}

