/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class TargetCardInLibrarySharingLandType
extends TargetCardInLibrary {
    private static final FilterCard filterBasicLandCard = new FilterCard("basic land card");

    TargetCardInLibrarySharingLandType(int minNumTargets, int maxNumTargets) {
        super(minNumTargets, maxNumTargets, filterBasicLandCard);
    }

    private TargetCardInLibrarySharingLandType(TargetCardInLibrarySharingLandType target) {
        super((TargetCardInLibrary)target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canTarget(UUID playerId, UUID id, Ability source, Cards cards, Game game) {
        if (!super.canTarget(playerId, id, source, cards, game)) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        Card card1 = game.getCard((UUID)this.getTargets().get(0));
        Card card2 = game.getCard(id);
        if (card1 == null) return false;
        if (card2 == null) return false;
        if (!card1.getSubtype(game).stream().filter(SubType.getLandTypes()::contains).anyMatch(subType -> card2.hasSubtype(subType, game))) return false;
        return true;
    }

    public TargetCardInLibrarySharingLandType copy() {
        return new TargetCardInLibrarySharingLandType(this);
    }

    static {
        filterBasicLandCard.add(Predicates.or((Iterable)SubType.getLandTypes().stream().map(SubType::getPredicate).collect(Collectors.toSet())));
        filterBasicLandCard.add((Predicate)SuperType.BASIC.getPredicate());
    }
}

