/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.CreatureAttackedWhichPlayerWatcher;

class NacatlWarPrideEffect
extends OneShotEffect {
    NacatlWarPrideEffect() {
        super(Outcome.Benefit);
        this.staticText = "create X tokens that are copies of {this} and that are tapped and attacking, where X is the number of creatures defending player controls. Exile the tokens at the beginning of the next end step";
    }

    private NacatlWarPrideEffect(NacatlWarPrideEffect effect) {
        super((OneShotEffect)effect);
    }

    public NacatlWarPrideEffect copy() {
        return new NacatlWarPrideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent origNactalWarPride = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (origNactalWarPride == null) {
            return false;
        }
        CreatureAttackedWhichPlayerWatcher PlayerAttackedWatcher2 = (CreatureAttackedWhichPlayerWatcher)game.getState().getWatcher(CreatureAttackedWhichPlayerWatcher.class);
        UUID defenderId = PlayerAttackedWatcher2.getPlayerAttackedThisTurnByCreature(source.getSourceId());
        int count = 0;
        if (defenderId != null) {
            count = game.getBattlefield().countAll((FilterPermanent)new FilterControlledCreaturePermanent(), defenderId, game);
        }
        if (count == 0) {
            return false;
        }
        ArrayList copies = new ArrayList();
        Player controller = game.getPlayer(source.getControllerId());
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(controller.getId(), null, false, count, true, true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(origNactalWarPride, game));
        effect.apply(game, source);
        copies.addAll(effect.getAddedPermanents());
        if (!copies.isEmpty()) {
            FixedTargets blueprintTarget = new FixedTargets(copies, game);
            ExileTargetEffect exileEffect = new ExileTargetEffect();
            exileEffect.setTargetPointer((TargetPointer)blueprintTarget.copy()).setText("exile the tokens");
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect), source);
            return true;
        }
        return false;
    }
}

