/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NagaFleshcrafterEffect
extends OneShotEffect {
    NagaFleshcrafterEffect() {
        super(Outcome.Benefit);
        this.staticText = "each other creature you control becomes a copy of that creature until end of turn";
    }

    private NagaFleshcrafterEffect(NagaFleshcrafterEffect effect) {
        super((OneShotEffect)effect);
    }

    public NagaFleshcrafterEffect copy() {
        return new NagaFleshcrafterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            if (permanent.getId().equals(creature.getId())) continue;
            game.copyPermanent(Duration.EndOfTurn, permanent, creature.getId(), source, null);
        }
        return true;
    }
}

