/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.KorSoldierToken;
import mage.players.Player;
import mage.target.TargetPermanent;

class NahiriTheLithomancerFirstAbilityEffect
extends OneShotEffect {
    NahiriTheLithomancerFirstAbilityEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 1/1 white Kor Soldier creature token. You may attach an Equipment you control to it";
    }

    private NahiriTheLithomancerFirstAbilityEffect(NahiriTheLithomancerFirstAbilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public NahiriTheLithomancerFirstAbilityEffect copy() {
        return new NahiriTheLithomancerFirstAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            KorSoldierToken token = new KorSoldierToken();
            if (token.putOntoBattlefield(1, game, source, source.getControllerId())) {
                for (UUID tokenId : token.getLastAddedTokenIds()) {
                    Permanent equipmentPermanent;
                    TargetPermanent target;
                    Permanent tokenPermanent = game.getPermanent(tokenId);
                    if (tokenPermanent == null || !(target = new TargetPermanent(0, 1, StaticFilters.FILTER_CONTROLLED_PERMANENT_EQUIPMENT, true)).canChoose(controller.getId(), source, game) || !controller.chooseUse(this.outcome, "Attach an Equipment you control to the created " + tokenPermanent.getIdName() + '?', source, game) || !target.choose(Outcome.Neutral, source.getControllerId(), source.getSourceId(), source, game) || (equipmentPermanent = game.getPermanent(target.getFirstTarget())) == null) continue;
                    Permanent attachedTo = game.getPermanent(equipmentPermanent.getAttachedTo());
                    if (attachedTo != null) {
                        attachedTo.removeAttachment(equipmentPermanent.getId(), source, game);
                    }
                    tokenPermanent.addAttachment(equipmentPermanent.getId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

