/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleTargetEffect;
import mage.abilities.effects.common.discard.DiscardControllerEffect;
import mage.abilities.keyword.CompleatedAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.n.NahiriLoyaltyPredicate;
import mage.cards.n.NahiriTheUnforgivingRestrictionEffect;
import mage.cards.n.NahiriTheUnforgivingTokenEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetCreaturePermanent;

public final class NahiriTheUnforgiving
extends CardImpl {
    private static final FilterCard filter = new FilterCard("Equipment or creature with lesser manavalue than Nahiri's loyalty");

    public NahiriTheUnforgiving(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{1}{R}{R/W/P}{W}");
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)NahiriLoyaltyPredicate.instance);
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.NAHIRI);
        this.setStartingLoyalty(5);
        this.addAbility((Ability)CompleatedAbility.getInstance());
        LoyaltyAbility ability1 = new LoyaltyAbility((Effect)new AttacksIfAbleTargetEffect(Duration.UntilYourNextTurn).setText("Until your next turn, up to one target creature attacks"), 1);
        ability1.addEffect((Effect)new NahiriTheUnforgivingRestrictionEffect());
        ability1.addTarget((Target)new TargetCreaturePermanent(0, 1));
        this.addAbility((Ability)ability1);
        LoyaltyAbility ability2 = new LoyaltyAbility((Effect)new DiscardControllerEffect(1), 1);
        ability2.addEffect((Effect)new DrawCardSourceControllerEffect(1).concatBy(", then"));
        this.addAbility((Ability)ability2);
        LoyaltyAbility ability3 = new LoyaltyAbility((Effect)new NahiriTheUnforgivingTokenEffect(), 0);
        ability3.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.addAbility((Ability)ability3);
    }

    private NahiriTheUnforgiving(NahiriTheUnforgiving card) {
        super((CardImpl)card);
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)NahiriLoyaltyPredicate.instance);
    }

    public NahiriTheUnforgiving copy() {
        return new NahiriTheUnforgiving(this);
    }
}

