/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;

class NahiriTheUnforgivingTokenEffect
extends OneShotEffect {
    NahiriTheUnforgivingTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target creature or Equipment card with mana value less than Nahiri's loyalty from your graveyard. Create a token that's a copy of it. That token gains haste. Exile it at the beginning of the next end step.";
    }

    private NahiriTheUnforgivingTokenEffect(NahiriTheUnforgivingTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public NahiriTheUnforgivingTokenEffect copy() {
        return new NahiriTheUnforgivingTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(controller.getId(), null, true);
        effect.setSavedPermanent((Permanent)new PermanentCard(card, source.getControllerId(), game));
        effect.apply(game, source);
        effect.exileTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

