/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.PlayAdditionalLandsControllerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

class NahirisLithoformingSacrificeEffect
extends OneShotEffect {
    NahirisLithoformingSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Sacrifice X lands. For each land sacrificed this way, draw a card. You may play X additional lands this turn.";
    }

    private NahirisLithoformingSacrificeEffect(NahirisLithoformingSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public NahirisLithoformingSacrificeEffect copy() {
        return new NahirisLithoformingSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) == 0) {
            return false;
        }
        int landCount = game.getBattlefield().count(TargetSacrifice.makeFilter((FilterPermanent)StaticFilters.FILTER_LAND), source.getControllerId(), source, game);
        landCount = Math.min((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0), landCount);
        TargetSacrifice target = new TargetSacrifice(landCount, landCount, (FilterPermanent)StaticFilters.FILTER_LAND);
        player.choose(this.outcome, (Target)target, source, game);
        int counter = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++counter;
        }
        player.drawCards(counter, source, game);
        game.addEffect((ContinuousEffect)new PlayAdditionalLandsControllerEffect(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), Duration.EndOfTurn), source);
        return true;
    }
}

