/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.dynamicvalue.common.CardsInAllGraveyardsCount;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class NamelessRaceEffect
extends ReplacementEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent("white nontoken permanents your opponents control");
    private static final FilterCard filter2 = new FilterCard("white cards in their graveyards");

    NamelessRaceEffect() {
        super(Duration.EndOfGame, Outcome.LoseLife);
        this.staticText = "pay any amount of life. The amount you pay can't be more than the total number of white nontoken permanents your opponents control plus the total number of white cards in their graveyards";
    }

    private NamelessRaceEffect(NamelessRaceEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public NamelessRaceEffect copy() {
        return new NamelessRaceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int cardsInGraveyards;
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (creature == null || controller == null) {
            return false;
        }
        int permanentsInPlay = new PermanentsOnBattlefieldCount(filter).calculate(game, source, null);
        int maxAmount = Math.min(permanentsInPlay + (cardsInGraveyards = new CardsInAllGraveyardsCount(filter2).calculate(game, source, null)), controller.getLife());
        int payAmount = controller.getAmount(0, maxAmount, "Pay up to " + maxAmount + " life", source, game);
        PayLifeCost cost = new PayLifeCost(payAmount);
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        Card sourceCard = game.getCard(source.getSourceId());
        game.informPlayers((sourceCard != null ? sourceCard.getLogName() : "") + ": " + controller.getLogName() + " pays " + payAmount + " life");
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(payAmount, payAmount, Duration.WhileOnBattlefield), source);
        creature.addInfo("life paid", CardUtil.addToolTipMarkTags((String)("Life paid: " + payAmount)), game);
        this.discard();
        return false;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter2.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
        filter2.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getOwnerPredicate());
    }
}

