/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NantukoMentorEffect
extends OneShotEffect {
    NantukoMentorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature gets +X/+X until end of turn, where X is that creature's power";
    }

    private NantukoMentorEffect(NantukoMentorEffect effect) {
        super((OneShotEffect)effect);
    }

    public NantukoMentorEffect copy() {
        return new NantukoMentorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetPermanent != null) {
            BoostTargetEffect effect = new BoostTargetEffect(targetPermanent.getPower().getValue(), targetPermanent.getPower().getValue(), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

