/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.token.SquirrelToken;
import mage.game.stack.Spell;
import mage.players.Player;

class NantukoShrineEffect
extends OneShotEffect {
    NantukoShrineEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "that player creates X 1/1 green Squirrel creature tokens, where X is the number of cards in all graveyards with the same name as that spell";
    }

    private NantukoShrineEffect(NantukoShrineEffect effect) {
        super((OneShotEffect)effect);
    }

    public NantukoShrineEffect copy() {
        return new NantukoShrineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null && (controller = game.getPlayer(spell.getControllerId())) != null) {
            int count = 0;
            String name = spell.getName();
            FilterCard filterCardName = new FilterCard();
            filterCardName.add((Predicate)new NamePredicate(name));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                count += player.getGraveyard().count(filterCardName, game);
            }
            if (count > 0) {
                new SquirrelToken().putOntoBattlefield(count, game, source, spell.getControllerId());
            }
            return true;
        }
        return false;
    }
}

