/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreatureOrPlaneswalker;

class NarsetOfTheAncientWayDrawEffect
extends OneShotEffect {
    NarsetOfTheAncientWayDrawEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw a card, then you may discard a card. When you discard a nonland card this way, {this} deals damage equal to that card's mana value to target creature or planeswalker.";
    }

    private NarsetOfTheAncientWayDrawEffect(NarsetOfTheAncientWayDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public NarsetOfTheAncientWayDrawEffect copy() {
        return new NarsetOfTheAncientWayDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        if (player.getHand().isEmpty() || !player.chooseUse(Outcome.Discard, "Discard a card?", source, game)) {
            return false;
        }
        Card card = player.discardOne(false, false, source, game);
        if (card == null || card.isLand(game)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(card.getManaValue()), false, "{this} deals damage to target creature or planeswalker equal to the discarded card's mana value");
        ability.addTarget((Target)new TargetCreatureOrPlaneswalker());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

