/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.NecronWarriorToken;
import mage.players.Player;

class NecronMonolithEffect
extends OneShotEffect {
    NecronMonolithEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill three cards. For each creature card milled this way, create a 2/2 black Necron Warrior artifact creature token";
    }

    private NecronMonolithEffect(NecronMonolithEffect effect) {
        super((OneShotEffect)effect);
    }

    public NecronMonolithEffect copy() {
        return new NecronMonolithEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = player.millCards(3, source, game).count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        if (count > 0) {
            game.processAction();
            new NecronWarriorToken().putOntoBattlefield(count, game, source);
        }
        return true;
    }
}

