/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.SpellStack;
import mage.game.stack.StackObject;

class NeerdivDeviousDiverTriggeredAbility
extends TriggeredAbilityImpl {
    NeerdivDeviousDiverTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.addEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()).concatBy("and"));
        this.setTriggerPhrase("Whenever you cast a spell from your graveyard or activate an ability of a card in your graveyard, ");
    }

    private NeerdivDeviousDiverTriggeredAbility(NeerdivDeviousDiverTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NeerdivDeviousDiverTriggeredAbility copy() {
        return new NeerdivDeviousDiverTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: 
            case ACTIVATED_ABILITY: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case SPELL_CAST: {
                return Optional.ofNullable(event.getTargetId()).map(arg_0 -> ((Game)game).getSpell(arg_0)).map(Spell::getFromZone).map(arg_0 -> ((Zone)Zone.GRAVEYARD).match(arg_0)).orElse(false);
            }
            case ACTIVATED_ABILITY: {
                return Optional.ofNullable(event.getTargetId()).map(arg_0 -> ((SpellStack)game.getStack()).getStackObject(arg_0)).map(StackObject::getStackAbility).map(Ability::getSourceId).filter(uuid -> Zone.GRAVEYARD.match(game.getState().getZone(uuid))).map(arg_0 -> ((Game)game).getOwnerId(arg_0)).map(arg_0 -> ((NeerdivDeviousDiverTriggeredAbility)this).isControlledBy(arg_0)).orElse(false);
            }
        }
        return false;
    }
}

