/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class NefariousLichDamageReplacementEffect
extends ReplacementEffectImpl {
    private int amount = 0;

    NefariousLichDamageReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "If damage would be dealt to you, exile that many cards from your graveyard instead. If you can't, you lose the game.";
    }

    private NefariousLichDamageReplacementEffect(NefariousLichDamageReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.amount = effect.amount;
    }

    public NefariousLichDamageReplacementEffect copy() {
        return new NefariousLichDamageReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(event.getPlayerId());
        if (controller != null) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(this.amount, new FilterCard("card in your graveyard"));
            if (target.canChoose(controller.getId(), source, game) && controller.choose(Outcome.Exile, (Target)target, source, game)) {
                HashSet<Card> cards = new HashSet<Card>(this.amount);
                for (UUID targetId : target.getTargets()) {
                    Card card = controller.getGraveyard().get(targetId, game);
                    if (card == null) continue;
                    cards.add(card);
                }
                controller.moveCardsToExile(cards, source, game, true, null, "");
                return true;
            }
            controller.lost(game);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getControllerId())) {
            this.amount = event.getAmount();
            return true;
        }
        return false;
    }
}

