/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentCard;
import mage.game.stack.Spell;
import mage.players.Player;

class NephaliaAcademyEffect
extends ReplacementEffectImpl {
    private UUID cardId;
    private int zoneChangeCounter;

    public NephaliaAcademyEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a spell or ability an opponent controls causes you to discard a card, you may reveal that card and put it on top of your library instead of putting it anywhere else.";
    }

    private NephaliaAcademyEffect(NephaliaAcademyEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.cardId = effect.cardId;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public NephaliaAcademyEffect copy() {
        return new NephaliaAcademyEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARD_CARD || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getType() == GameEvent.EventType.DISCARD_CARD) {
            return event.getPlayerId().equals(source.getControllerId());
        }
        return event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.cardId) && game.getState().getZoneChangeCounter(event.getTargetId()) == this.zoneChangeCounter && ((ZoneChangeEvent)event).getFromZone() == Zone.HAND && ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event.getType() == GameEvent.EventType.DISCARD_CARD) {
            Card card = game.getCard(event.getTargetId());
            if (card != null) {
                boolean isAnOpponentEffect = false;
                MageObject object = game.getObject(event.getSourceId());
                if (object instanceof PermanentCard) {
                    isAnOpponentEffect = game.getOpponents(source.getControllerId()).contains(((PermanentCard)object).getControllerId());
                } else if (object instanceof Spell) {
                    isAnOpponentEffect = game.getOpponents(source.getControllerId()).contains(((Spell)object).getControllerId());
                } else if (object instanceof Card) {
                    isAnOpponentEffect = game.getOpponents(source.getControllerId()).contains(((Card)object).getOwnerId());
                }
                if (isAnOpponentEffect) {
                    this.cardId = card.getId();
                    this.zoneChangeCounter = game.getState().getZoneChangeCounter(this.cardId);
                }
            }
            return false;
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            Player controller = game.getPlayer(source.getControllerId());
            Card card = game.getCard(event.getTargetId());
            if (controller != null && card != null) {
                this.cardId = null;
                this.zoneChangeCounter = 0;
                if (controller.chooseUse(this.outcome, "Put " + card.getIdName() + " on top of your library instead?", source, game)) {
                    CardsImpl cardsToLibrary = new CardsImpl(card);
                    controller.revealCards(card.getName(), (Cards)cardsToLibrary, game);
                    controller.putCardsOnTopOfLibrary((Cards)cardsToLibrary, game, source, false);
                    return true;
                }
            }
        }
        return false;
    }
}

