/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.CanBeEnchantedByPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class NettlevineBlightEffect
extends OneShotEffect {
    NettlevineBlightEffect() {
        super(Outcome.Detriment);
        this.staticText = "sacrifice this permanent and attach {this} to a creature or land you control";
    }

    private NettlevineBlightEffect(NettlevineBlightEffect effect) {
        super((OneShotEffect)effect);
    }

    public NettlevineBlightEffect copy() {
        return new NettlevineBlightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent nettlevineBlight = game.getPermanent(source.getSourceId());
        Player newController = null;
        if (controller != null && nettlevineBlight != null) {
            Permanent enchantedPermanent = game.getPermanent(nettlevineBlight.getAttachedTo());
            if (enchantedPermanent != null) {
                newController = game.getPlayer(enchantedPermanent.getControllerId());
                enchantedPermanent.sacrifice(source, game);
            }
            if (newController != null) {
                Card nettlevineBlightCard;
                Permanent chosenPermanent;
                FilterPermanent filter = new FilterPermanent("creature or land permanent you control");
                filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
                filter.add((Predicate)new ControllerIdPredicate(newController.getId()));
                filter.add((Predicate)new CanBeEnchantedByPredicate((MageObject)nettlevineBlight));
                TargetPermanent target = new TargetPermanent(filter);
                target.withNotTarget(true);
                if (target.canChoose(newController.getId(), source, game) && newController.choose(this.outcome, (Target)target, source, game) && (chosenPermanent = game.getPermanent(target.getFirstTarget())) != null && (nettlevineBlightCard = game.getCard(source.getSourceId())) != null) {
                    game.getState().setValue("attachTo:" + nettlevineBlight.getId(), (Object)chosenPermanent);
                    chosenPermanent.addAttachment(nettlevineBlight.getId(), source, game);
                    return true;
                }
            }
        }
        return false;
    }
}

