/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class NeverHappenedEffect
extends OneShotEffect {
    NeverHappenedEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from that player's graveyard or hand and exile it.";
    }

    private NeverHappenedEffect(NeverHappenedEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeverHappenedEffect copy() {
        return new NeverHappenedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Cards cards;
        TargetCard target;
        FilterNonlandCard filter;
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        if (controller.chooseUse(this.outcome, "Exile a card from hand or graveyard?", null, "Hand", "Graveyard", source, game)) {
            filter = new FilterNonlandCard("nonland card in " + opponent.getName() + "'s hand");
            target = new TargetCard(Zone.HAND, (FilterCard)filter);
            target.withNotTarget(true);
            cards = opponent.getHand();
        } else {
            filter = new FilterNonlandCard("nonland card in " + opponent.getName() + "'s graveyard");
            target = new TargetCard(Zone.GRAVEYARD, (FilterCard)filter);
            target.withNotTarget(true);
            cards = opponent.getGraveyard();
        }
        if (controller.choose(this.outcome, cards, target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
        }
        return true;
    }
}

