/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.PreventNextDamageFromChosenSourceEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

enum NewWayForwardPreventionApplier implements PreventNextDamageFromChosenSourceEffect.ApplierOnPrevention
{
    instance;


    public boolean apply(PreventionEffectData data, Target target, GameEvent event, Ability source, Game game) {
        if (data == null || data.getPreventedDamage() <= 0) {
            return false;
        }
        int prevented = data.getPreventedDamage();
        UUID objectControllerId = game.getControllerId(target.getFirstTarget());
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(prevented).setTargetPointer((TargetPointer)new FixedTarget(objectControllerId)), false);
        ability.addEffect((Effect)new DrawCardSourceControllerEffect(prevented));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    public String getText() {
        return "When damage is prevented this way, {this} deals that much damage to that source's controller and you draw that many cards";
    }
}

