/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;

class NeyithOfTheDireHuntTriggeredAbility
extends TriggeredAbilityImpl {
    NeyithOfTheDireHuntTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
    }

    private NeyithOfTheDireHuntTriggeredAbility(NeyithOfTheDireHuntTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BATCH_FIGHT || event.getType() == GameEvent.EventType.DECLARE_BLOCKERS_STEP || event.getType() == GameEvent.EventType.BATCH_BLOCK_NONCOMBAT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case BATCH_FIGHT: {
                Object value = game.getState().getValue("batchFight_" + event.getData());
                if (!(value instanceof Set)) {
                    return false;
                }
                Set permanents = (Set)value;
                return permanents.stream().map(mor -> mor.getPermanentOrLKIBattlefield(game)).filter(Objects::nonNull).map(Controllable::getControllerId).anyMatch(this.getControllerId()::equals);
            }
            case BATCH_BLOCK_NONCOMBAT: {
                Object value = game.getState().getValue("becameBlocked_" + event.getData());
                if (!(value instanceof Set)) {
                    return false;
                }
                Set permanents = (Set)value;
                return permanents.stream().map(mor -> mor.getPermanentOrLKIBattlefield(game)).filter(Objects::nonNull).map(Controllable::getControllerId).anyMatch(this.getControllerId()::equals);
            }
            case DECLARE_BLOCKERS_STEP: {
                return game.getCombat().getGroups().stream().filter(CombatGroup::getBlocked).map(CombatGroup::getAttackers).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getControllerId(arg_0)).anyMatch(this.getControllerId()::equals);
            }
        }
        return false;
    }

    public NeyithOfTheDireHuntTriggeredAbility copy() {
        return new NeyithOfTheDireHuntTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more creatures you control fight or become blocked, draw a card.";
    }
}

