/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NibelheimAflameEffect
extends OneShotEffect {
    NibelheimAflameEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature you control. It deals damage equal to its power to each other creature";
    }

    private NibelheimAflameEffect(NibelheimAflameEffect effect) {
        super((OneShotEffect)effect);
    }

    public NibelheimAflameEffect copy() {
        return new NibelheimAflameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        if (power < 1) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE, source.getControllerId(), source, game)) {
            if (creature.equals(permanent)) continue;
            creature.damage(power, permanent.getId(), source, game);
        }
        return true;
    }
}

