/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveVariableCountersSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

public final class NightDealings
extends CardImpl {
    public NightDealings(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{B}{B}");
        this.addAbility((Ability)new NightDealingsTriggeredAbility());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new NightDealingsSearchEffect(), (Cost)new ManaCostsImpl("{2}{B}{B}"));
        ability.addCost((Cost)new RemoveVariableCountersSourceCost(CounterType.THEFT));
        this.addAbility((Ability)ability);
    }

    private NightDealings(NightDealings card) {
        super((CardImpl)card);
    }

    public NightDealings copy() {
        return new NightDealings(this);
    }

    private static final class NightDealingsSearchEffect
    extends OneShotEffect {
        private NightDealingsSearchEffect() {
            super(Outcome.DrawCard);
            this.staticText = "Search your library for a nonland card with mana value X, reveal it, put it into your hand, then shuffle";
        }

        private NightDealingsSearchEffect(NightDealingsSearchEffect effect) {
            super((OneShotEffect)effect);
        }

        public NightDealingsSearchEffect copy() {
            return new NightDealingsSearchEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null) {
                return false;
            }
            int cmc = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            FilterNonlandCard filter = new FilterNonlandCard("nonland card with mana value " + cmc);
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, cmc));
            TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
            player.searchLibrary(target, source, game);
            Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
            if (card != null) {
                player.revealCards(source, (Cards)new CardsImpl(card), game);
                player.moveCards(card, Zone.HAND, source, game);
            }
            player.shuffleLibrary(source, game);
            return true;
        }
    }

    private static final class NightDealingsEffect
    extends OneShotEffect {
        private NightDealingsEffect() {
            super(Outcome.Damage);
            this.staticText = "put that many theft counters on {this}";
        }

        private NightDealingsEffect(NightDealingsEffect effect) {
            super((OneShotEffect)effect);
        }

        public NightDealingsEffect copy() {
            return new NightDealingsEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent permanent = source.getSourcePermanentIfItStillExists(game);
            Integer damageAmount = (Integer)this.getValue("damageAmount");
            return permanent != null && damageAmount != null && damageAmount > 0 && permanent.addCounters(CounterType.THEFT.createInstance(damageAmount.intValue()), source.getControllerId(), source, game);
        }
    }

    private static final class NightDealingsTriggeredAbility
    extends TriggeredAbilityImpl {
        private NightDealingsTriggeredAbility() {
            super(Zone.BATTLEFIELD, (Effect)new NightDealingsEffect());
            this.setTriggerPhrase("Whenever a source you control deals damage to another player, ");
        }

        private NightDealingsTriggeredAbility(NightDealingsTriggeredAbility ability) {
            super((TriggeredAbilityImpl)ability);
        }

        public NightDealingsTriggeredAbility copy() {
            return new NightDealingsTriggeredAbility(this);
        }

        public boolean checkEventType(GameEvent event, Game game) {
            return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
        }

        public boolean checkTrigger(GameEvent event, Game game) {
            if (this.isControlledBy(event.getTargetId()) || !this.isControlledBy(game.getControllerId(event.getSourceId()))) {
                return false;
            }
            this.getEffects().setValue("damageAmount", (Object)event.getAmount());
            return true;
        }
    }
}

