/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class NightsnareDiscardEffect
extends OneShotEffect {
    NightsnareDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "Target opponent reveals their hand. You may choose a nonland card from it. If you do, that player discards that card. If you don't, that player discards two cards";
    }

    private NightsnareDiscardEffect(NightsnareDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (player == null || controller == null) {
            return false;
        }
        if (player.getHand().isEmpty()) {
            return true;
        }
        CardsImpl revealedCards = new CardsImpl();
        revealedCards.addAll((Collection)player.getHand());
        Card sourceCard = game.getCard(source.getSourceId());
        player.revealCards(sourceCard != null ? sourceCard.getIdName() : "Discard", (Cards)revealedCards, game);
        if (!controller.chooseUse(this.outcome, "Choose a card to discard? (Otherwise " + player.getLogName() + " has to discard 2 cards).", source, game)) {
            player.discard(2, false, false, source, game);
            return true;
        }
        TargetCard target = new TargetCard(1, Zone.HAND, (FilterCard)new FilterNonlandCard());
        if (controller.choose(Outcome.Benefit, (Cards)revealedCards, target, source, game)) {
            Card card = revealedCards.get(target.getFirstTarget(), game);
            player.discard(card, false, source, game);
        }
        return true;
    }

    public NightsnareDiscardEffect copy() {
        return new NightsnareDiscardEffect(this);
    }
}

