/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class NightveilSpecterExileEffect
extends OneShotEffect {
    NightveilSpecterExileEffect() {
        super(Outcome.Discard);
        this.staticText = "that player exiles the top card of their library";
    }

    private NightveilSpecterExileEffect(NightveilSpecterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && (card = player.getLibrary().getFromTop(game)) != null) {
            player.moveCardsToExile(card, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null));
            return true;
        }
        return false;
    }

    public NightveilSpecterExileEffect copy() {
        return new NightveilSpecterExileEffect(this);
    }
}

