/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class NimbleTrapfinderWatcher
extends Watcher {
    private static final FilterPermanent filter = new FilterCreaturePermanent();
    private final Map<UUID, Set<MageObjectReference>> playerMap = new HashMap<UUID, Set<MageObjectReference>>();

    NimbleTrapfinderWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (!filter.match((Object)permanent, game)) {
            return;
        }
        this.playerMap.computeIfAbsent(event.getPlayerId(), u -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game));
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    boolean checkPlayer(UUID sourceId, Game game) {
        Permanent permanent = game.getPermanent(sourceId);
        if (permanent == null) {
            return !this.playerMap.computeIfAbsent(game.getOwnerId(sourceId), u -> new HashSet()).isEmpty();
        }
        return this.playerMap.computeIfAbsent(permanent.getControllerId(), u -> new HashSet()).stream().anyMatch(mor -> !mor.refersTo((MageObject)permanent, game));
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.CLERIC.getPredicate(), SubType.ROGUE.getPredicate(), SubType.WARRIOR.getPredicate(), SubType.WIZARD.getPredicate()}));
    }
}

