/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterTeamPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NimbusChampionEffect
extends OneShotEffect {
    private static final FilterTeamPermanent filter = new FilterTeamPermanent(SubType.WARRIOR, "Warriors your team controls");

    NimbusChampionEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature to its owner's hand if that creature's power is less than or equal to the number of Warriors your team controls";
    }

    private NimbusChampionEffect(NimbusChampionEffect effect) {
        super((OneShotEffect)effect);
    }

    public NimbusChampionEffect copy() {
        return new NimbusChampionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null || creature.getPower().getValue() > new PermanentsOnBattlefieldCount((FilterPermanent)filter).calculate(game, source, (Effect)this)) {
            return false;
        }
        return new ReturnToHandTargetEffect().apply(game, source);
    }
}

