/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToBattlefieldWithCounterEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NineLivesFamiliarEffect
extends OneShotEffect {
    NineLivesFamiliarEffect() {
        super(Outcome.Benefit);
        this.staticText = "return it to the battlefield with one fewer revival counter on it";
    }

    private NineLivesFamiliarEffect(NineLivesFamiliarEffect effect) {
        super((OneShotEffect)effect);
    }

    public NineLivesFamiliarEffect copy() {
        return new NineLivesFamiliarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("permanentLeftBattlefield");
        if (permanent == null) {
            return false;
        }
        int counters = permanent.getCounters(game).getCount(CounterType.REVIVAL) - 1;
        ReturnSourceFromGraveyardToBattlefieldWithCounterEffect effect = new ReturnSourceFromGraveyardToBattlefieldWithCounterEffect(CounterType.REVIVAL.createInstance(counters), false);
        effect.setText(this.staticText);
        effect.apply(game, source);
        return true;
    }
}

