/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NinjasKunaiEffect
extends OneShotEffect {
    NinjasKunaiEffect() {
        super(Outcome.Benefit);
    }

    private NinjasKunaiEffect(NinjasKunaiEffect effect) {
        super((OneShotEffect)effect);
    }

    public NinjasKunaiEffect copy() {
        return new NinjasKunaiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object object = this.getValue("attachedPermanent");
        Player player = game.getPlayer(source.getControllerId());
        if (!(object instanceof Permanent) || player == null) {
            return false;
        }
        Permanent permanent = (Permanent)object;
        Permanent targetedPermanent = game.getPermanent(source.getFirstTarget());
        if (targetedPermanent == null) {
            Player targetedPlayer = game.getPlayer(source.getFirstTarget());
            if (targetedPlayer != null) {
                targetedPlayer.damage(3, permanent.getId(), source, game);
            }
        } else {
            targetedPermanent.damage(3, permanent.getId(), source, game);
        }
        return true;
    }

    public String getText(Mode mode) {
        String name = "Ninja's Kunai";
        Object object = this.getValue("attachedPermanent");
        if (object instanceof Permanent) {
            name = ((Permanent)object).getName();
        }
        return name + " deals 3 damage to any target.";
    }
}

