/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.players.Player;

class NissaWorldsoulSpeakerEffect
extends ContinuousEffectImpl {
    private static final FilterPermanentCard filter = new FilterPermanentCard();
    private final AlternativeCostSourceAbility alternativeCastingCostAbility = new AlternativeCostSourceAbility((Cost)new PayEnergyCost(8), (Condition)SourceIsSpellCondition.instance, null, (FilterCard)filter, true);

    public NissaWorldsoulSpeakerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You may pay eight {E} rather than pay the mana cost for permanent spells you cast";
    }

    private NissaWorldsoulSpeakerEffect(NissaWorldsoulSpeakerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public NissaWorldsoulSpeakerEffect copy() {
        return new NissaWorldsoulSpeakerEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

