/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.n.NivMizzetRebornTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class NivMizzetRebornEffect
extends OneShotEffect {
    NivMizzetRebornEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top ten cards of your library. For each color pair, choose a card that's exactly those colors from among them. Put the chosen cards into your hand and the rest on the bottom of your library in a random order.";
    }

    private NivMizzetRebornEffect(NivMizzetRebornEffect effect) {
        super((OneShotEffect)effect);
    }

    public NivMizzetRebornEffect copy() {
        return new NivMizzetRebornEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 10));
        if (cards.isEmpty()) {
            return false;
        }
        player.revealCards(source, (Cards)cards, game);
        NivMizzetRebornTarget target = new NivMizzetRebornTarget();
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
        player.moveCardsToHandWithInfo((Cards)toHand, source, game, true);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

